# Traces,  waveguides

from ipkiss.technology.technology import TechnologyTree
from ipkiss.technology import get_technology
from ipkiss.primitives.layer import Layer

TECH = get_technology()

# drawing traces
TECH.TRACE = TechnologyTree()
TECH.TRACE.DEFAULT_LAYER = TECH.PPLAYER.NONE
TECH.TRACE.CONTROL_SHAPE_LAYER = TECH.PPLAYER.NONE
TECH.TRACE.BEND_RADIUS = 150.0
TECH.TRACE.DRAW_CONTROL_SHAPE = False

# system wavelength
TECH.DEFAULT_WAVELENGTH = 1.55

# waveguides
TECH.WG_DEFAULTS = TechnologyTree()
TECH.WG_DEFAULTS.N_EFF = 2.4
TECH.WG_DEFAULTS.N_GROUP = 4.4
TECH.WG_DEFAULTS.LOSS_DB_PERM = 0.0
TECH.WG_DEFAULTS.CORE_LAYER = Layer(0)
