# Collections of default PCells
#
# The technology keys below are required keys for IPKISS
# You can change the values or refer them to your own technology keys, but their name should not be changed

from ipkiss.technology import get_technology
from ipkiss.technology.technology import DelayedInitTechnologyTree

TECH = get_technology()


# Default waveguide template used in routing
class WGTechTree(DelayedInitTechnologyTree):
    def initialize(self):
        from aluvia.components.waveguides.waveguide_traces import WG_TMPL

        self.WIRE = WG_TMPL()
        self.DEFAULT = self.WIRE


TECH.PCELLS.WG = WGTechTree()


# Auto-transition database
class TransitionTree(DelayedInitTechnologyTree):
    def initialize(self):
        # Note: we only create an empty transition database here. It will be filled elsewhere
        # (for example, please check aluvia/components/waveguides/wire/transition.py)
        from ipkiss3.pcell.trace.transitions.auto_transition.auto_transition_db import AutoTransitionDatabase

        db = AutoTransitionDatabase()
        self.AUTO_TRANSITION_DATABASE = db


TECH.PCELLS.TRANSITION = TransitionTree()


# default metal wires
class TechWireTree(DelayedInitTechnologyTree):
    def initialize(self):
        from aluvia.components.metal.wire import MetalWireTemplate

        self.WIRE = MetalWireTemplate()
        self.DEFAULT = MetalWireTemplate()


TECH.PCELLS.METAL = TechWireTree()
