from ipkiss.technology.technology import ProcessTechnologyTree, TechnologyTree
from ipkiss.technology import get_technology
from ipkiss.process.layer import ProcessLayer, PatternPurpose, PPLayer

TECH = get_technology()

TECH.PROCESS = ProcessTechnologyTree()
TECH.PROCESS.WG = ProcessLayer(name="Al2O3WaveguideLayer", extension="WG")
TECH.PROCESS.NONE = ProcessLayer(name="None", extension="NONE")
TECH.PROCESS.EBEAM = ProcessLayer(name="E-beam", extension="EBEAM")
TECH.PROCESS.HEATER = ProcessLayer(name="Heater", extension="HEATER")
TECH.PROCESS.M1 = ProcessLayer(name="MetalLayer", extension="M1")

TECH.PURPOSE = TechnologyTree()

TECH.PURPOSE.LF = TechnologyTree()
TECH.PURPOSE.DF = TechnologyTree()

TECH.PURPOSE.DRAWING = PatternPurpose(name="Drawing", extension="DRW")
TECH.PURPOSE.PINREC = PatternPurpose(name="PinRecognition", extension="PINREC")
TECH.PURPOSE.DICELINE = PatternPurpose(name="DicingLine", extension="DICELINE")
TECH.PURPOSE.TEXT = PatternPurpose(name="Text", extension="TEXT")
TECH.PURPOSE.CROSSTALK = PatternPurpose(name="Crosstalk", extension="CROSSTALK")
TECH.PURPOSE.BLEED = PatternPurpose(name="Bleed", extension="BLEED")
TECH.PURPOSE.DOC = PatternPurpose(name="Documentation", extension="DOC")
TECH.PURPOSE.UNUSED = PatternPurpose(name="Unused", extension="UNUSED")
TECH.PURPOSE.ERROR = PatternPurpose(name="Error", extension="ERR")
TECH.PURPOSE.BBOX = PatternPurpose(name="Bounding Box", extension="BBOX")
TECH.PURPOSE.TRACE = PatternPurpose(name="Trace of waveguide template", extension="TRACE")
TECH.PURPOSE.DF_AREA = TECH.PURPOSE.UNUSED
TECH.PURPOSE.LF_AREA = TECH.PURPOSE.UNUSED
TECH.PURPOSE.LF.LINE = TECH.PURPOSE.UNUSED
TECH.PURPOSE.DF.LINE = TECH.PURPOSE.UNUSED
TECH.PURPOSE.DF.POLYGON = TECH.PURPOSE.UNUSED
TECH.PPLAYER = TechnologyTree()

TECH.PPLAYER.WG = PPLayer(TECH.PROCESS.WG, TECH.PURPOSE.DRAWING, name="WG")
TECH.PPLAYER.WG_PINREC = PPLayer(TECH.PROCESS.WG, TECH.PURPOSE.PINREC, name="WG_PINREC")
TECH.PPLAYER.DICELINE = PPLayer(TECH.PROCESS.NONE, TECH.PURPOSE.DICELINE, name="DICELINE")
TECH.PPLAYER.TEXT = PPLayer(TECH.PROCESS.NONE, TECH.PURPOSE.TEXT, name="TEXT")
TECH.PPLAYER.EBEAM_DICELINE = PPLayer(TECH.PROCESS.EBEAM, TECH.PURPOSE.DICELINE, name="EBEAM_DICELINE")
TECH.PPLAYER.EBEAM_TEXT = PPLayer(TECH.PROCESS.EBEAM, TECH.PURPOSE.TEXT, name="EBEAM_TEXT")
TECH.PPLAYER.HEATER = PPLayer(TECH.PROCESS.HEATER, TECH.PURPOSE.DRAWING, name="HEATER")
TECH.PPLAYER.HEATER_CROSSTALK = PPLayer(TECH.PROCESS.HEATER, TECH.PURPOSE.CROSSTALK, name="HEATER_CROSSTALK")
TECH.PPLAYER.BLEED = PPLayer(TECH.PROCESS.NONE, TECH.PURPOSE.BLEED, name="BLEED_REGION")
TECH.PPLAYER.M1 = PPLayer(TECH.PROCESS.M1, TECH.PURPOSE.DRAWING, name="M1")

TECH.PPLAYER.ERROR = TechnologyTree()
TECH.PPLAYER.ERROR.GENERIC = PPLayer(TECH.PROCESS.NONE, TECH.PURPOSE.ERROR, name="ERROR")
TECH.PPLAYER.PINREC = PPLayer(TECH.PROCESS.NONE, TECH.PURPOSE.PINREC, name="PINREC")
TECH.PPLAYER.DOC = PPLayer(TECH.PROCESS.NONE, TECH.PURPOSE.DOC, name="DOC")
TECH.PPLAYER.NONE = PPLayer(TECH.PROCESS.NONE, TECH.PURPOSE.UNUSED, name="NONE")

TECH.PPLAYER.WG.TEXT = TECH.PPLAYER.DOC

# required for Ipkiss.eda compatibility
TECH.PPLAYER.WG_TRACE = PPLayer(TECH.PROCESS.WG, TECH.PURPOSE.TRACE, name="WG_TRACE")
