# Display styles
#
# Required keys for ipkiss visualization
# Note: this information is also used when exporting to an OpenAccess database: a display.drf file is made, which
# contains the relevant information about the color styles.

from ipkiss.technology import get_technology
from ipkiss.technology.technology import TechnologyTree, DelayedInitTechnologyTree
from ipkiss.visualisation.display_style import DisplayStyle, DisplayStyleSet
from ipkiss.visualisation import color
from ipkiss.visualisation import stipple

TECH = get_technology()


DISPLAY_WHITE = DisplayStyle(color=color.COLOR_WHITE, stipple=stipple.STIPPLE_FILLED, edgewidth=0.0)
DISPLAY_WG = DisplayStyle(color=color.COLOR_BLUE_VIOLET, stipple=stipple.STIPPLE_FILLED, edgewidth=0.0, alpha=0.5)
DISPLAY_WG_PINREC = DisplayStyle(color=color.COLOR_BLUE_VIOLET, stipple=stipple.STIPPLE_DOTS, edgewidth=0.0, alpha=0.5)
DISPLAY_DICELINE = DisplayStyle(color=color.COLOR_BLACK, stipple=stipple.STIPPLE_LINES_V, edgewidth=0.0, alpha=0.6)
DISPLAY_TEXT = DisplayStyle(color=color.COLOR_COPPER, stipple=stipple.STIPPLE_FILLED, edgewidth=0.0, alpha=0.3)
DISPLAY_EBEAM_DICELINE = DisplayStyle(color=color.COLOR_GRAY, stipple=stipple.STIPPLE_DOTS, edgewidth=0.0, alpha=0.4)
DISPLAY_EBEAM_TEXT = DisplayStyle(color=color.COLOR_GRAY, stipple=stipple.STIPPLE_LINES_V, edgewidth=0.0, alpha=0.5)
DISPLAY_HEATER = DisplayStyle(color=color.COLOR_DEEP_GREEN, stipple=stipple.STIPPLE_FILLED, edgewidth=0.0, alpha=0.4)
DISPLAY_HEATER_CROSSTALK = DisplayStyle(
    color=color.COLOR_MAGENTA,
    stipple=stipple.STIPPLE_DOTS,
    edgewidth=0,
    alpha=0.1,
)
DISPLAY_BLEED = DisplayStyle(color=color.COLOR_BLACK, stipple=stipple.STIPPLE_LINES_V, edgewidth=0.0, alpha=0.1)
DISPLAY_M1 = DisplayStyle(color=color.COLOR_GRAY, stipple=stipple.STIPPLE_FILLED, edgewidth=0.0, alpha=0.5)


class TechDisplayTree(DelayedInitTechnologyTree):
    def initialize(self):

        self.PREDEFINED_STYLE_SETS = TechnologyTree()
        style_set = DisplayStyleSet()
        style_set.background = DISPLAY_WHITE

        # Note: the order in which the layer:color pairs are added here decides the drawing order.
        for key in TECH.PPLAYER.keys():
            try:
                style_set += [(eval("TECH.PPLAYER.{}".format(key)), eval("DISPLAY_{}".format(key)))]
            except:
                pass

        from ipkiss.visualisation.color import Color
        from numpy import linspace

        # Visualization for simple Layers which may be present
        style_set += [
            (i, DisplayStyle(color=Color(name="gray_" + str(i), red=c_val, green=c_val, blue=c_val), alpha=0.5))
            for i, c_val in enumerate(linspace(0.9, 0.0, num=256))
        ]
        self.DEFAULT_DISPLAY_STYLE_SET = style_set  # required


TECH.DISPLAY = TechDisplayTree()  # required
