############################################################################################
# Design rule and dimension settings:
#
# This file contains default settings which are used throughout IPKISS and PICAZZO
# - Some global settings
# - Per process layer settings, like minimum width, default width, default bend radius, ....
############################################################################################

from ipkiss.technology import get_technology
from ipkiss.technology.technology import TechnologyTree

TECH = get_technology()

TECH.TECH = TechnologyTree()
# Required by ipkiss/picazzo, but not strictly used
TECH.WG = TechnologyTree()
TECH.WG.WIRE_WIDTH = 0.5
TECH.WG.TRENCH_WIDTH = 2.0
TECH.WG.CLADDING_WIDTH = TECH.WG.WIRE_WIDTH + 2 * TECH.WG.TRENCH_WIDTH

TECH.WG.BEND_RADIUS = 150.0
TECH.WG.SPACING = 0.1
TECH.WG.DC_SPACING = TECH.WG.WIRE_WIDTH + 0.18
TECH.WG.SHORT_STRAIGHT = 2.0
TECH.WG.SHORT_TRANSITION_LENGTH = 5.0
TECH.WG.SHORT_TAPER_LENGTH = TECH.WG.SHORT_TRANSITION_LENGTH
TECH.WG.OVERLAP_EXTENSION = 0.020
TECH.WG.OVERLAP_TRENCH = 0.010
TECH.WG.EXPANDED_WIDTH = 0.8
TECH.WG.EXPANDED_TAPER_LENGTH = 3.0
TECH.WG.EXPANDED_STRAIGHT = 5.0
TECH.WG.ANGLE_STEP = 1.0
TECH.WG.SLOT_WIDTH = 0.15
TECH.WG.SLOTTED_WIRE_WIDTH = 0.7

# Metal Tree
TECH.METAL = TechnologyTree()
TECH.METAL.LINE_WIDTH = 50.0  # Default line width of metal wire
TECH.METAL.DEFAULT_PROCESS = TECH.PROCESS.M1  # Default process for metal wiring
