# ###############################################################
# ALUVIA: Demonstration library for Photonics Design
#
# copyright Luceda Photonics 2016
#
# ###############################################################
# Technology data
# ###############################################################
#
# The following imports load the different parts of the Technology tree
#

# INIT file
# Sets the technology name and loads all modules
# Be careful when changing the order of importing modules,
# since there may be interdependencies
# and risk for circular imports through ipkiss and/or picazzo

# Import the base technology from IPKISS.
from ipkiss.technology import TECHNOLOGY as TECH

__all__ = ["TECH"]
TECH.name = "ALUVIA"
from technologies.base_ipkiss import admin as _  # Admin: auto-name generator, ...
from technologies.base_ipkiss import mask as _  # Constants for mask polarity
from . import metrics as _  # Metrics: unit, grid, ...
from . import layers as _  # Process layers and drawing purposes

# Initializes the PCELL tree to add PCELLS to the TECH.
from technologies.base_ipkiss import pcells as _
from . import ports as _  # Ports: Settings about ports sizes in L-EDIT.
from . import dimension as _

# Blocks: Sets the block spacing for IOColumn.
from . import blocks as _

# to handle metals and via's
# traces: Sets the rules that handles the drawing of waveguides and traces.
from . import traces as _
from . import gdsii as _  # Gdsii: Sets the GDSII import-export layers.

# Display: Display settings for visualisation in IPKISS
from . import display as _
from . import pcells as _  # All PCell that are in the TECH-tree
from . import transitions as _  # Auto-transitions

# from . import materials as _                              # Materials and material stacks
from . import vfab as _  # Virtual fabrication

try:
    import oatools
    from . import openaccess as _  # All OpenAccess-related settings.
except:
    pass
