from ipkiss3.pcell.trace.transition import RestrictedTraceTemplateProperty
from picazzo3.traces.wire_wg.transitions import LinearWindowWaveguideTransition, LinearWindowWaveguideTransitionFromPort
from .waveguide_traces import WG_TMPL
from ipkiss.technology import get_technology

TECH = get_technology()


class LinearTransition(LinearWindowWaveguideTransition):
    """Simple transition based on a LinearWindowTraceTransition.
    This class can be adjusted to the user's needs (currently, it contains only some boilerplate)
    """

    _name_prefix = "T_LIN"
    start_trace_template = RestrictedTraceTemplateProperty((WG_TMPL))
    end_trace_template = RestrictedTraceTemplateProperty((WG_TMPL))


class LinearTransitionFromPort(LinearTransition, LinearWindowWaveguideTransitionFromPort):

    _name_prefix = "T_LIN_FP"

    class Layout(LinearTransition.Layout, LinearWindowWaveguideTransitionFromPort.Layout):
        def _default_length(self):
            # calculate taper length dynamically based on difference in core width
            w1 = self.start_trace_template.core_width
            w2 = self.end_trace_template.core_width
            a = 10.0
            return max(1.0, abs(a * (w2**2 - w1**2)))

        """Make sure we call the correct _generate_ports. The LinearWindowWaveguideTransitionFromPort
        knows how to position the end port based on the length of the transition."""
        _generate_ports = LinearWindowWaveguideTransitionFromPort.Layout._generate_ports
