from ipkiss3.pcell.photonics.waveguide import WindowWaveguideTemplate, TemplatedWindowWaveguide
from ipkiss3.pcell.trace.window.window import PathTraceWindow
from ipkiss.technology import get_technology

TECH = get_technology()


class WG_TMPL(WindowWaveguideTemplate):
    """
    Waveguide Template with Al2O3 Core.
    """

    _templated_class = TemplatedWindowWaveguide
    _name_prefix = "WG_TMPL"

    class Layout(WindowWaveguideTemplate.Layout):
        _doc_properties = ["core_width"]

        def _default_core_layer(self):
            return TECH.PPLAYER.WG

        def _default_core_width(self):
            return 0.6

        def _default_windows(self):
            wg_wd2 = self.core_width / 2.0
            windows = [
                PathTraceWindow(layer=self.core_layer, start_offset=-wg_wd2, end_offset=wg_wd2),
            ]
            return windows
