from ipkiss3 import all as i3


class _Template(i3.PCell):
    """
    width x height design template.
    """

    def _default_name(self):
        return "TEMPLATE_5000_5000"

    class Layout(i3.LayoutView):

        _doc_properties = ["template_width", "template_height", "edge_width", "bleed"]
        template_width = i3.PositiveNumberProperty(default=5000.0, doc="width of the template")
        template_height = i3.PositiveNumberProperty(default=5000.0, doc="height of the template")
        edge_width = i3.PositiveNumberProperty(default=15)
        bleed = i3.PositiveNumberProperty(default=200, doc="height of the template")

        def _generate_elements(self, elems):
            template_width = self.template_width
            template_height = self.template_height
            edge_width = self.edge_width
            bleed = self.bleed
            dicingLine = i3.ShapeRectangle(
                center=(template_width / 2.0, template_height / 2.0),
                box_size=(template_width - edge_width, template_height - edge_width),
            )

            bleedRegion = i3.ShapeRectangle(
                center=(template_width / 2.0, template_height / 2.0),
                box_size=(template_width - bleed, template_height - bleed),
            )

            elems += i3.Path(shape=dicingLine, layer=i3.TECH.PPLAYER.DICELINE, line_width=edge_width)
            elems += i3.Path(shape=bleedRegion, layer=i3.TECH.PPLAYER.BLEED, line_width=bleed)

            return elems


@i3.lock_properties()
class Template5000x5000(_Template):
    """
    5000x5000 design template.
    """
    _doc_properties = []

    def _default_template_width(self):
        return 5000.0

    def _default_template_height(self):
        return 5000.0

    def _default_name(self):
        return "TEMPLATE_5000_5000"

    class Layout(_Template.Layout):
        _doc_properties = []

        def _default_template_width(self):
            return 5000.0

        def _default_template_height(self):
            return 5000.0


@i3.lock_properties()
class Template10000x10000(_Template):
    """
    10000x10000 design template.
    """
    _doc_properties = []

    def _default_name(self):
        return "TEMPLATE_10000_10000"

    class Layout(_Template.Layout):
        _doc_properties = []

        def _default_template_width(self):
            return 10000.0

        def _default_template_height(self):
            return 10000.0
