from .technology import TECH

from .components.waveguides.waveguide_traces import WG_TMPL
from .components.waveguides.cells import (
    StripWaveguide,
    StripWaveguide_369,
    StripWaveguide_405,
    TaperPCell,
    SBend,
    EulerBendPcell,
    ArcPathPcell,
)
from .components.ybranch.cell import YBranchPcell
from .components.dir_coupler.cell import DirectionalCouplerPcell
from .components.edge_coupler.cell import LinearEdgeTaperPCell
from .components.ring_resonator.cell import RingRes_1x1Pcell, RingRes_2x2Pcell
from .components.mmi.cell import MMI_1x2Pcell, MMI_2x2Pcell, MMI_nxmPcell
from .components.spiral.cell import SquareSpiralPcell, SquareSpiralEulerPcell, SpiralPcell, SpiralEulerPcell
from .components.waveguides.waveguide_transitions import (
    LinearTransition,
    LinearTransitionFromPort,
)
from .components.template.cell import Template5000x5000, Template10000x10000
from .components.metal.bondpad import DCPad, DCPadArray
from .components.metal.heater import TemplatedHeaterWaveguide, HeaterTemplate, HeaterWaveguide
from .components.metal.wire import MetalWireTemplate, MetalWire, DCTaper, DCBend, ElectricalWindowWire

from ipkiss3.pcell.photonics.waveguide import TemplatedWindowWaveguide
from ipkiss3.pcell.photonics.rounded_waveguide import RoundedWaveguide

# In __all__, we store all accessible components
templates = [
    "WG_TMPL",
    "HeaterTemplate",
    "MetalWireTemplate",
]

cells = [
    "StripWaveguide",
    "StripWaveguide_369",
    "StripWaveguide_405",
    "TaperPCell",
    "LinearEdgeTaperPCell",
    "SBend",
    "YBranchPcell",
    "DirectionalCouplerPcell",
    "EulerBendPcell",
    "ArcPathPcell",
    "RingRes_1x1Pcell",
    "RingRes_2x2Pcell",
    "MMI_1x2Pcell",
    "MMI_2x2Pcell",
    "MMI_nxmPcell",
    "SquareSpiralPcell",
    "SquareSpiralEulerPcell",
    "SpiralPcell",
    "SpiralEulerPcell",
    "Template5000x5000",
    "Template10000x10000",
    "HeaterWaveguide",
    "MetalWire",
    "DCTaper",
    "DCBend",
    "DCPad",
    "DCPadArray",
]

__all__ = (
    templates
    + cells
    + [
        "TemplatedWindowWaveguide",
        "TemplatedHeaterWaveguide",
        "RoundedWaveguide",
        "ElectricalWindowWire",
    ]
)
