import aluvia.all as pdk
import ipkiss3.all as i3

wg1 = pdk.StripWaveguide_369()
wg1.Layout().visualize(annotate=True)

wg2 = pdk.StripWaveguide_405()
wg2.Layout().visualize(annotate=True)

taper = pdk.TaperPCell()
taper.Layout().visualize(annotate=True)

sbend = pdk.SBend()
sbend.Layout().visualize(annotate=True)

example_transitions = i3.Circuit(
    insts={
        "wg_1": wg1,
        "wg_2": wg2,
    },
    specs=[
        i3.Place("wg_2", (180, 0)),
        i3.ConnectBend("wg_1:out0", "wg_2:in0"),
    ],
)
example_transitions_lay = example_transitions.Layout()
example_transitions_lay.write_gdsii("example_transitions.gds")
example_transitions_lay.visualize()
